function Initialize()
	print( "LevelControl - initialize" )
	
	--[[ not possible in script because of swig<->lua troubles with std::tr1::shared_ptr returned by CreateEntity
	     it seems as if this shared_ptr instance is never destroyed and therefore the object never will be deleted
	
	local pos = game.NodeData()
	pos:SetPosition( GAME:GetGameState():GetEntityManager():GetEntity( "checkpoint0" ):GetNode():GetPosition() )
	
	GAME:GetGameState():GetEntityFactory():CreateEntity( "Ball", "ball", pos )
	GAME:GetGameState():GetEntityManager():GetEntity( "ball" ):Enable()
	
	game.RenderSystem_GetInstance():GetDefaultViewport():GetCameraPointer():SetPosition( pos.m_position )
	GAME:GetGameState():GetEntityFactory():CreateEntity( "Camera", "camera", pos )
	GAME:GetGameState():GetEntityManager():GetEntity( "camera" ):Enable()
	
	]]
	
	OWNER:SetString( "currentCheckpoint", "Checkpoint0" )

end

function Update()

end

function HandleEvent( event )
	if event:GetID() == "Event_EntityCollision" then
		if event:GetEntityID1() == "ball" then
			HandleCollision( event:GetEntityID2() )
		elseif event:GetEntityID2() == "ball" then
			HandleCollision( event:GetEntityID1() )
		end
	end
end

function HandleCollision( entity )
	if entity:find( "checkpoint" ) then
		OWNER:SetString( "currentCheckpoint", entity )
	elseif entity:find( "Goal" ) then
		game.EventManager_GetInstance():SendEvent( game.Event_SwitchGameState_Create( "GameStateEditor" ) )
	elseif entity:find( "DeathZone" ) then
		ResetBallToCheckpoint()
	end
end

function ResetBallToCheckpoint()
	local pos = GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "currentCheckpoint" ) ):GetNode():GetPosition()
	local ball = GAME:GetGameState():GetEntityManager():GetEntity( "ball" )
	ball:GetNode():SetPosition( pos )
	ball:GetPhysicsBody():SetLinearVelocity( game.Vector( 0, 0 ) )
end