function Scale( deltas )
	movable = false
	local zoom = game.RenderSystem_GetInstance():GetDefaultViewport():GetCameraPointer():GetZoom().m_x
	local scale = game.Vector( GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "selectedEntity" ) ):GetNode():GetScale() )
	scale.m_x = scale.m_x + deltas.m_x / zoom
	scale.m_y = scale.m_y + deltas.m_y / zoom
	
	GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "selectedEntity" ) ):GetNode():SetScale( scale )
	GAME:GetGameState():GetEntityManager():GetEntity( "Selection" ):GetNode():SetScale( scale )
end

function Rotate( deltas )
	movable = false
	local zoom = game.RenderSystem_GetInstance():GetDefaultViewport():GetCameraPointer():GetZoom().m_x
	local angle = GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "selectedEntity" ) ):GetNode2D():GetAngle():ToFloat()
	
	angle = angle - deltas.m_x / 5 / zoom
	
	GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "selectedEntity" ) ):GetNode2D():SetAngle( game.Radian( angle ) )
	GAME:GetGameState():GetEntityManager():GetEntity( "Selection" ):GetNode2D():SetAngle( game.Radian( angle ) )
end

function Translate()
	local zoom = game.RenderSystem_GetInstance():GetDefaultViewport():GetCameraPointer():GetZoom().m_x
	local cursor = GAME:GetGameState():GetEntityManager():GetEntity( "cursor" )
	local pos = game.Vector( cursor:GetFloat( "posx" ), cursor:GetFloat( "posy" ) )
	pos.m_x = pos.m_x + OWNER:GetFloat( "offsetx" )
	pos.m_y = pos.m_y + OWNER:GetFloat( "offsety" )
	
	pos.m_z = 1
	GAME:GetGameState():GetEntityManager():GetEntity( OWNER:GetString( "selectedEntity" ) ):GetNode():SetPosition( pos )
	
	pos.m_z = 0.1
	GAME:GetGameState():GetEntityManager():GetEntity( "Selection" ):GetNode():SetPosition( pos )
end

function SelectEntity()
	for i = 0, OWNER:GetInt( "numRotators" ) - 1 do
		if SelectIfClicked( "Rotator" .. i ) then
			return
		end
	end
	
	for i = 0, OWNER:GetInt( "numDeathZones" ) - 1 do
		if SelectIfClicked( "DeathZone" .. i ) then
			return
		end
	end
	
	for i = 0, OWNER:GetInt( "numGoals" ) - 1 do
		if SelectIfClicked( "Goal" .. i ) then
			return
		end
	end
	
	for i = 0, OWNER:GetInt( "numWalls" ) - 1 do
		if SelectIfClicked( "Wall" .. i ) then
			return
		end
	end
	
	for i = 0, OWNER:GetInt( "numCheckpoints" ) - 1 do
		if SelectIfClicked( "Checkpoint" .. i ) then
			return
		end
	end
	
	OWNER:SetString( "selectedEntity", "" )
end

function SelectIfClicked( entityID )
	local ent = GAME:GetGameState():GetEntityManager():GetEntity( entityID )
	local angle = ent:GetNode2D():GetAngle():ToFloat()
	local cursor = GAME:GetGameState():GetEntityManager():GetEntity( "cursor" )
	local cursorPos = game.Vector( cursor:GetFloat( "posx" ), cursor:GetFloat( "posy" ) )
	
	local ret = GetDistanceToLine( ent:GetNode():GetPosition(), angle, cursorPos ) < math.abs( ent:GetNode():GetScale().m_y / 2 ) and
		        GetDistanceToLine( ent:GetNode():GetPosition(), angle + math.pi / 2, cursorPos ) < math.abs( ent:GetNode():GetScale().m_x / 2 )
	
	OWNER:SetString( "selectedEntity", entityID )
	OWNER:SetFloat( "offsetx", ent:GetNode():GetPosition().m_x - cursorPos.m_x )
	OWNER:SetFloat( "offsety", ent:GetNode():GetPosition().m_y - cursorPos.m_y )
	
	return ret
end

function GetDistanceToLine( position, angle, referencePoint )
	local x2 = position.m_x + math.cos( angle )
	local y2 = position.m_y + math.sin( angle )
	local A = position.m_y - y2
    local B = x2 - position.m_x
	local C = -position.m_x * A - B * position.m_y
	local factor = math.sqrt( A * A + B * B )
	A = A / factor
	B = B / factor
	C = C / factor
	
	return math.abs( A * referencePoint.m_x + B * referencePoint.m_y + C )
end